package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;

import androidx.appcompat.app.AppCompatActivity;

import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;

/**
 * Screen display test
 */
public class ScreenActivity extends BaseActivity implements View.OnClickListener {
    private int[] colorArr = {Color.RED, Color.BLACK, Color.GREEN, Color.DKGRAY, Color.WHITE};
    private int colorIndex = 0;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;
    private LinearLayout linearLayoutBg;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_screen);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);

        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        linearLayoutBg = findViewById(R.id.linear_bg);
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("Screen display test");
    }

    @Override
    protected void setListener() {
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
        linearLayoutBg.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
            case R.id.linear_bg:
                setColor();
                break;
        }
    }

    private void setColor() {
        if (colorArr.length == colorIndex) {
            return;
        }
        linearLayoutBg.setBackgroundColor(colorArr[colorIndex]);
        colorIndex++;
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
